function [ akt,phint ] = WangZ_PilotAllocation( options )
%WANGZ_PILOTALLOCATION Summary of this function goes here
%   Detailed explanation goes here

%% construct the pilots and reflection coefficients
T3 = ceil((options.K-1)*options.N/options.M);
rho = floor(options.N/options.M);
nu = options.N-options.M*rho;
            
akt = zeros(options.K,T3);
phint = zeros(options.N,T3);
            
LAMBDA_k1 = zeros(options.K,options.N-nu);
LAMBDA_k2 = zeros(options.K,nu);
for k = 2:options.K
    Tk = ((k-2)*nu+1):((k-1)*nu);
    LAMBDA_k2(k,:) = Tk-(ceil(Tk/options.N)-1)*options.N;
    ii = 1;
    for nn = 1:options.N
        if (find(LAMBDA_k2(k,:)==nn))
            continue;
        end
        LAMBDA_k1(k,ii) = nn;
        ii = ii+1;
    end
end
for t = 1:(options.K-1)*rho
    akt(ceil(t/rho)+1,t) = 1;
    Om_t = LAMBDA_k1(ceil(t/rho)+1,((t-(ceil(t/rho)-1)*rho-1)*options.M+1):(t-(ceil(t/rho)-1)*rho-1)*options.M+options.M);
    phint(Om_t,t) = 1;
end

for t = ((options.K-1)*rho+1):T3
    Kt = [];
    Nt = [];
    for j = ((t-(options.K-1)*rho-1)*options.M+1):min([(t-(options.K-1)*rho)*options.M,(options.K-1)*options.N-(options.K-1)*options.M*rho])
        if (find(Kt==(ceil(j/nu)+1)))
            Kt = Kt;
        else
            Kt = [Kt,(ceil(j/nu)+1)];
        end
        if (find(Nt==LAMBDA_k2(ceil(j/nu)+1,j-(ceil(j/nu)-1)*nu)))
            Nt = Nt;
        else
            Nt = [Nt,LAMBDA_k2(ceil(j/nu)+1,j-(ceil(j/nu)-1)*nu)];
        end
    end
    akt(Kt,t) = 1;
    phint(Nt,t) = 1;
end

end

